﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport marży - szczegóły</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
		<script runat="server">

			public class ParametryContext : ContextBase
			{
				private bool _ignorujZaliczkowe = false;
                private readonly Soneta.Handel.Forms.DokHandloweViewInfo.WParams _wparams;

				internal FromTo Okres
				{
					get
					{
						return this._wparams == null ? FromTo.All : this._wparams.Okres;
					}
				}
				
				internal Kontrahent Kontrahent
				{
					get
					{
						return this._wparams == null ? null : this._wparams.Kontrahent;
					}
				}

				internal bool IsKontrahent
				{
					get
					{
						return this.Kontrahent != null;
					}
				}
				
				public ParametryContext(Context cx)
					: base(cx)
				{
					cx.Get<Soneta.Handel.Forms.DokHandloweViewInfo.WParams>(out this._wparams);
				}

				[Soneta.Tools.Priority(10)]
				public bool IgnorujZaliczkowe
				{
					get
					{
						return this._ignorujZaliczkowe;
					}
					set
					{
						this._ignorujZaliczkowe = value;
						OnChanged(EventArgs.Empty);
					}
				}

                [Soneta.Tools.Priority(20)]
                public bool IgnorujDuplikaty {
                    get {
						return true;
                    }
                }
                
                [Soneta.Tools.Priority(30)]
				[Caption("Korekty kosztu (KWPZ)")]
                public bool RaportowacKwpz {
                    get {
						return true;
                    }
                }
			}

			ParametryContext _parametry;

			[Context]
			public ParametryContext Parametry
			{
				get
				{
					return _parametry;
				}
				set
				{
					_parametry = value;
				}
			}

			void dc_ContextLoad(object sender, EventArgs args)
			{
                Row[] rows = (Row[])_dc[typeof(Row[])];
                ListWithView lwv = new ListWithView(rows, HandelModule.GetInstance(_dc.Session).DokHandlowe.WgDaty);
                _grid.DataSource = lwv;
                
				_listaKWPZ.Visible = this.Parametry.RaportowacKwpz;
				sIgnorujZaliczkowe.Visible = this.Parametry.IgnorujZaliczkowe;

				if (this.Parametry.RaportowacKwpz)
				{
					_gridKWPZ.DataSource = CreateKWPZView(this._dc,this.Parametry, rows);
				}
			}	
			
			private void Grid_BeforeRow(Object sender, RowEventArgs args)
			{
				DokumentHandlowy dok = (DokumentHandlowy)args.Row;
                args.VisibleRow = !dok.Anulowany;

                bool warunek1 = true;
                bool warunek2 = true;
                
				if (this.Parametry.IgnorujZaliczkowe)
				{
					warunek1 = dok.Definicja.EdycjaWartosci != EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę && !dok.Anulowany;
				}
                if(this.Parametry.IgnorujDuplikaty)
                {
                    warunek2 = !dok.Definicja.DuplikatWartosci;
                }
                args.VisibleRow = warunek1 && warunek2;
			}
			#region Lista KWPZ.

			private static Soneta.Business.View CreateKWPZView(DataContext dc, ParametryContext pars, Row[] rows)
			{
				HandelModule hm = HandelModule.GetInstance(dc);
				Magazyn magazyn = (Magazyn)dc[typeof(Magazyn)];

				Soneta.Business.View vw = new SubTable(
					magazyn == null ? hm.DokHandlowe.WgDaty : hm.DokHandlowe.WgMagazyn[magazyn] as SubTable
					, pars.Okres).CreateView();
				
				vw.Condition &= new FieldCondition.Equal("Definicja", hm.DefDokHandlowych.KorektaPZWZ);
				if (pars.IsKontrahent)
				{
					vw.Condition &= new FieldCondition.Equal("Kontrahent", pars.Kontrahent);
					vw.FilterCondition += delegate(object sender, ConditionEventArgs e)
					{
						DokumentHandlowy mag = (DokumentHandlowy)e.Row;
						while (mag.Definicja == hm.DefDokHandlowych.KorektaPZWZ)
						{
							mag = mag.Nadrzędne[TypRelacjiHandlowej.KorektaPWZ];
						}
						Row[] han = new Row[] {
							mag.Nadrzędne[TypRelacjiHandlowej.HandlowoMagazynowa]
							, mag.Podrzędne[TypRelacjiHandlowej.HandlowoMagazynowa]
						};
						foreach (Row h in han)
						{
							if (h != null)
							{
								e.Accepted = Array.IndexOf<Row>(rows, h) >= 0;
								return;
							}
						}						
					};
				}
				return vw;
			}
				
			protected void GridKWPZ_BeforeRow(object sender, RowEventArgs args)
			{
				DokumentHandlowy dok = (DokumentHandlowy)args.Row;
				if (dok.Anulowany || !testDok(dok))
					args.VisibleRow = false;
			}

			bool testDok(DokumentHandlowy dok)
			{
				foreach (DokumentHandlowy wz in dok.Nadrzędne)
				{
					if (wz.Definicja == dok.Module.DefDokHandlowych.KorektaPZWZ)
					{
						if (testDok(wz)) return true;
					}
					else if (wz.KierunekMagazynu == KierunekPartii.Rozchód)
					{
						if (JestHandlowy(wz) || wz.DokumentyHandlowe.Length > 0) return true;
					}
				}
				return false;
			}
			private static bool JestHandlowy(DokumentHandlowy dok)
			{
				return KategoriaHandlowa.HandelPierwszy <= dok.Kategoria && dok.Kategoria <= KategoriaHandlowa.HandelOstatni;
			}
			void GridKWPZ_AfterRender(Object sender, EventArgs args)
			{
				decimal v = ColZakupNettoK.TotalValue == null ? 0 : (decimal)ColZakupNettoK.TotalValue;
				v += (decimal)ColWartZakupu.TotalValue;
				ZakupyRazemLabel.EditValue = v;

				decimal vs = 0m;
				vs += (decimal)ColWartSprzed.TotalValue;
				ZyskRazemLabel.EditValue = vs - v;

				if (vs != 0)
					MarzaRazemLabel.EditValue = new Percent((vs - v) / vs);
				else
					MarzaRazemLabel.EditValue = Percent.Blank;

				if (v != 0)
					NarzutRazemLabel.EditValue = new Percent((vs - v) / v);
				else
					NarzutRazemLabel.EditValue = Percent.Blank;
			}

			#endregion	
		</script>
	</head>
	<body>
		<form method="post" runat="server" action="#">
			<p>
				<ea:datacontext id="_dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
                <eb:reportheader id="ReportHeader" title="Raport marży wg dokumentów|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
					runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres"></eb:reportheader>
				<font face="Verdana" size="2">Raport nie uwzględnia duplikatów.</font>
				<br />
				<ea:Section runat="server" ID="sIgnorujZaliczkowe">
					<font face="Verdana" size="2">Raport nie uwzględnia faktur zaliczkowych.</font>
					<br />
				</ea:Section>
					<ea:grid id="_grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
					RowsInRow="4" OnBeforeRow="Grid_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="4" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Align="Left" DataMember="Numer" Caption="Dokument handlowy" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn DataMember="Kontrahent" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="Data" Caption=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="DokumentMagazynowyData" Caption="Data" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćZakupu" ID="ColWartZakupu"
							Total="Sum" Caption="Wartość/Z" Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćZakupuTowar&#243;w"
							Total="Sum" Caption="towary" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćZakupuProdukt&#243;w"
							Total="Sum" Caption="produkty" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćSprzedaży" ID="ColWartSprzed"
							Total="Sum" Caption="Wartość/S" Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćSprzedażyTowar&#243;w"
							Total="Sum" Caption="towary" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćSprzedażyProdukt&#243;w"
							Total="Sum" Caption="produkty" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćSprzedażyUsług"
							Total="Sum" Caption="usługi" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.Marża" Total="Sum"
							Caption="Marża" Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.MarżaTowar&#243;w"
							Total="Sum" Caption="towary" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.MarżaProdukt&#243;w"
							Total="Sum" Caption="produkty" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćSprzedażyUsług"
							Total="Sum" Caption="usługi" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.NarzutProcent" Caption="Narzut %"
							Format="&lt;strong&gt;{0}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.NarzutTowar&#243;wProcent"
							Caption="towary" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.NarzutProdukt&#243;wProcent"
							Caption="produkty" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.MarżaProcent" Caption="Marża %"
							Format="&lt;strong&gt;{0}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.MarżaTowar&#243;wProcent"
							Caption="towary" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.MarżaProdukt&#243;wProcent"
							Caption="produkty" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" Caption=" " Format=" " runat="server"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<font face="Verdana" size="2">
					<br />
				</font>
				<ea:Section ID="_listaKWPZ" runat="server" Width="100%" >
				<font face="Verdana" size="2">Korekty kosztu (wynikające z korekt zakupu)</font>
				<br />
				<ea:grid id="_gridKWPZ" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
					OnAfterRender="GridKWPZ_AfterRender" OnBeforeRow="GridKWPZ_BeforeRow"  RowsInRow="2">
					<Columns>
						<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True" Rowspan=2></ea:GridColumn>
						<ea:GridColumn runat="server" DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn runat="server" DataMember="Kontrahent" Caption="Kontrahent" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="10" DataMember="DokumentMagazynowyData" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn runat="server" Width="10" Format="" Caption=" " EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="13" Align="Right" DataMember="WartośćWCenieZakupu" Total="Sum" Caption="Wartość/Z" Rowspan=2
							Format="{0:n}" ID="ColZakupNettoK" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn runat="server" Width="13" Align="Right" Caption="Wartość/S" Rowspan=2 Format="0"></ea:GridColumn>
                        <ea:GridColumn runat="server" Width="13" Align="Right" DataMember="Workers.ObrotyDokumentu.Marża" Total="Sum"
							Caption="Marża" Rowspan=2 Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn runat="server" Width="10" Align="Right" Caption="Narzut %" Rowspan=2 Format=" "></ea:GridColumn>
                        <ea:GridColumn runat="server" Width="10" Align="Right" Caption="Marża %" Rowspan=2 Format=" "></ea:GridColumn>
					</Columns>
				</ea:grid><br />
				<font face="Verdana" size="2">Wartość zakupu razem:
					<ea:DataLabel id="ZakupyRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>&nbsp;PLN<br />
					Marża razem:
					<ea:DataLabel id="ZyskRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>&nbsp;PLN,
					marża:
					<ea:DataLabel id="MarzaRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>, narzut:
					<ea:DataLabel id="NarzutRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel><br />
				</font>
				</ea:Section>
				<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter></p>
		</form>
	</body>
</html>

